/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import com.google.common.base.Strings;
import cz.insophy.inplan.tab.PropertySetter;
import cz.insophy.inplan.tab.PropertySetterFactory;
import cz.insophy.inplan.tab.PropertySetters;
import cz.insophy.inplan.xml.XmlUtils;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.annotation.Nonnull;

class CsvPropertySetterFactory
implements PropertySetterFactory<String> {
    private final DateFormat dateFormat;
    private final DateFormat dateTimeFormat;
    private final DecimalFormat numFormat;

    public CsvPropertySetterFactory(DateFormat dateFormat, DateFormat dateTimeFormat, DecimalFormat numFormat) {
        this.dateFormat = dateFormat;
        this.dateTimeFormat = dateTimeFormat;
        this.numFormat = numFormat;
    }

    @Override
    public PropertySetter<String> createStringSetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException {
                field.set(target, XmlUtils.cleanupString(s2));
            }
        };
    }

    @Override
    public PropertySetter<String> createPrimIntSetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException {
                field.setInt(target, Integer.parseInt(s2));
            }
        };
    }

    @Override
    public PropertySetter<String> createIntegerSetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException {
                field.set(target, Integer.parseInt(s2));
            }
        };
    }

    @Override
    public PropertySetter<String> createPrimLongDateSetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
                long time;
                if (Strings.isNullOrEmpty(s2)) {
                    throw new RuntimeException("null or empty value in String field");
                }
                try {
                    time = CsvPropertySetterFactory.this.dateTimeFormat.parse(s2).getTime();
                }
                catch (ParseException e) {
                    time = CsvPropertySetterFactory.this.dateFormat.parse(s2).getTime();
                }
                field.setLong(target, time);
            }
        };
    }

    @Override
    public PropertySetter<String> createLongDateSetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
                long time;
                try {
                    time = CsvPropertySetterFactory.this.dateTimeFormat.parse(s2).getTime();
                }
                catch (ParseException e) {
                    time = CsvPropertySetterFactory.this.dateFormat.parse(s2).getTime();
                }
                field.set(target, time);
            }
        };
    }

    @Override
    public PropertySetter<String> createPrimDoublePropertySetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
                field.setDouble(target, CsvPropertySetterFactory.this.numFormat.parse(s2).doubleValue());
            }
        };
    }

    @Override
    public PropertySetter<String> createDoublePropertySetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
                field.set(target, CsvPropertySetterFactory.this.numFormat.parse(s2).doubleValue());
            }
        };
    }

    @Override
    public PropertySetter<String> createPrimBooleanPropertySetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException {
                field.setBoolean(target, Boolean.parseBoolean(s2));
            }
        };
    }

    @Override
    public PropertySetter<String> createBooleanPropertySetter(final Field field) {
        return new PropertySetters.AbstractStringPropertySetter(field){

            @Override
            public void parseString(@Nonnull String s2, @Nonnull Object target) throws IllegalAccessException {
                field.set(target, Boolean.parseBoolean(s2));
            }
        };
    }
}

